var Board = require("../lib/firmata").Board;
var board = new Board("/dev/cu.usbmodem1411");

board.on("ready", function() {
  console.log("ready");
  var SW_SERIAL0 = board.SERIAL_PORT_IDs.SW_SERIAL0;

  board.serialConfig({
    portId: SW_SERIAL0,
    baud: 9600,
    bytesToRead: 0,
    rxPin: 10,
    txPin: 11
  });

  var commands = [
    // "#0 P1500 T100",
    // "#0 P2400 T500",
    // "#0 P600 T1000",
    // "#0 P2400 T1000",
    // "#0 P1500 T100",
    "0 4000 1000",
    "0 6000 1000",
    "0 8000 1000",
  ];


  var index = 0;

  function update() {
    var command = commands[index];
    var data = command.split(" ").map(Number);
    var delay = data[2];
    // var delay = Number(/T(\d.+)/.exec(command)[1]);
    // var data = command.split("").map(function(character) {
    //   return character.charCodeAt(0);
    // });

    // Add lf, cr
    // data.push(10, 13);
    // board.serialWrite(SW_SERIAL0, data1;

    position(data[0], data[1]);


    index++;

    if (index === commands.length) {
      index = 0;
    }

    setTimeout(update, delay);
  }

  function position(channel, target) {
    var data = [
      0x84,
      channel & 0x7F, target & 0x7F, (target >> 7) & 0x7F ];

    board.serialWrite(SW_SERIAL0, data);
  }


  update();
});
