/*
 Functional test for Firmata software serial.

 Step 1 (main board):
 Install the serial branch of Firmata: https://github.com/firmata/arduino/tree/serial
 Compile and upload StandardFirmata from the serial branch to an Arduino board

 Step 2 (serial test board - the mock serial peripheral device):
 Compile and upload the following on an Arduino Uno or similar board:
 https://gist.github.com/soundanalogous/3c21496ce3f1a1af2235

 Step 3:
 Wire the TX pin of the serial test board to pin 10 of the main board
 Wire the RX pin of the serial test board to pin 11 of the main board
 Wire GND between both boards
 Power the serial test board from an external power source
 [optional] - prepare another serial test board and wire TX to pin 12 and RX to pin 13

 Step 4:
 If you have an FTDI cable or similar (I use Adafruit console cable), wire the cable TX wire
 (green wire if using an Adafruit console cable) to the serial test board pin 10 and wire the RX
 wire to the serial test board pin 11. This will enable you to view data written to the serial test
 board.

 Step 5:
 Run this node js file. It should continuously print 0 - 255 to the node console.
*/


var Board = require("../lib/firmata").Board;
var board = new Board("/dev/tty.usbmodem1411");

board.on("ready", function() {
  console.log("READY");

  var swSerial0 = board.SERIAL_PORT_IDs.SW_SERIAL0;

  // since swSerial0 is last configed, it will be the current listening port
  board.serialConfig({
    portId: swSerial0,
    baud: 9600,
    bytesToRead: 4,
    rxPin: 10,
    txPin: 11
  });

  var logSerial0Data = function (data) {
    // board.serialFlush(swSerial0);
    console.log(new Buffer(data).toString("ascii"));
  };


  board.serialRead(swSerial0, logSerial0Data);

});
